<?php $__env->startSection('title', 'Manage Tags'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h2 style="font-size: 1.2rem;">Tags</h2>
        <button class="btn btn-primary" onclick="openTagModal()">
            <i class="fas fa-plus"></i> Add Tag
        </button>
    </div>

    <?php if(session('success')): ?>
    <div style="background: #d4edda; color: #155724; padding: 1rem; border-radius: 6px; margin-bottom: 1.5rem;">
        <?php echo e(session('success')); ?>

    </div>
    <?php endif; ?>

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Icon</th>
                    <th>Name</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><i class="<?php echo e($tag->icon); ?>"></i></td>
                    <td style="font-weight: 600;"><?php echo e($tag->name); ?></td>
                    <td>
                        <button class="action-btn btn-edit" onclick="editTag(<?php echo e(json_encode($tag)); ?>)">
                            <i class="fas fa-edit"></i>
                        </button>
                        <form action="<?php echo e(route('admin.tags.destroy', $tag->id)); ?>" method="POST" style="display:inline;" onsubmit="return confirm('Delete tag?')">
                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="action-btn btn-delete">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="3" style="padding: 2rem; text-align: center; color: #666;">No tags found</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <div class="pagination">
        <?php echo e($tags->links()); ?>

    </div>
</div>

<!-- Tag Modal -->
<div id="tagModal" class="modal">
    <div class="modal-content" style="max-width: 500px;">
        <h3 id="tagModalTitle">Add Tag</h3>
        <form id="tagForm" action="<?php echo e(route('admin.tags.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="_method" id="tagMethod" value="POST">

            <div class="form-group">
                <label>Name</label>
                <input type="text" name="name" id="tag_name" required>
            </div>

            <div class="form-group">
                <label>Icon Class (Optional)</label>
                <input type="text" name="icon" id="tag_icon" placeholder="fas fa-tag">
            </div>

            <div style="display:flex; gap: 10px; justify-content: flex-end;">
                <button type="button" class="btn btn-secondary" onclick="closeModal('tagModal')">Cancel</button>
                <button type="submit" class="btn btn-primary">Save Tag</button>
            </div>
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    function openTagModal() {
        document.getElementById('tagModalTitle').innerText = 'Add Tag';
        document.getElementById('tagForm').action = "<?php echo e(route('admin.tags.store')); ?>";
        document.getElementById('tagMethod').value = 'POST';
        document.getElementById('tagForm').reset();
        openModal('tagModal');
    }

    function editTag(tag) {
        document.getElementById('tagModalTitle').innerText = 'Edit Tag';
        document.getElementById('tagForm').action = "<?php echo e(url('admin/tags')); ?>/" + tag.id;
        document.getElementById('tagMethod').value = 'PUT';

        document.getElementById('tag_name').value = tag.name;
        document.getElementById('tag_icon').value = tag.icon;

        openModal('tagModal');
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Projects\Planters\back\resources\views/admin/tags/index.blade.php ENDPATH**/ ?>