<?php $__env->startSection('title', 'Manage Products'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h2 style="font-size: 1.2rem;">Products</h2>
        <a href="<?php echo e(route('admin.products.create')); ?>" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add Product
        </a>
    </div>

    <?php if(session('success')): ?>
    <div style="background: #d4edda; color: #155724; padding: 1rem; border-radius: 6px; margin-bottom: 1.5rem;">
        <?php echo e(session('success')); ?>

    </div>
    <?php endif; ?>

    <div style="overflow-x: auto;">
        <table style="width: 100%; border-collapse: collapse; margin-top: 1rem;">
            <thead>
                <tr style="text-align: left; border-bottom: 2px solid #f1f1f1;">
                    <th style="padding: 1rem;">Thumb</th>
                    <th style="padding: 1rem;">Title</th>
                    <th style="padding: 1rem;">Category</th>
                    <th style="padding: 1rem;">Price</th>
                    <th style="padding: 1rem;">Stock</th>
                    <th style="padding: 1rem;">Status</th>
                    <th style="padding: 1rem;">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr style="border-bottom: 1px solid #f1f1f1;">
                    <td style="padding: 1rem;">
                        <?php if($product->thumbnail): ?>
                        <div style="width: 50px; height: 50px; position: relative; border-radius: 8px; overflow: hidden; background: #f1f1f1;">
                            <img src="<?php echo e(asset(ltrim($product->thumbnail->path ?? '', '/'))); ?>" alt="" style="width: 100%; height: 100%; object-fit: cover;" onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                            <span style="display:none; position:absolute; inset:0; align-items:center; justify-content:center; color:#94a3b8;"><i class="fas fa-image"></i></span>
                        </div>
                        <?php else: ?>
                        <div style="width: 50px; height: 50px; background: #f1f1f1; border-radius: 8px; display: flex; align-items:center; justify-content:center;">
                            <i class="fas fa-image" style="color:#ccc;"></i>
                        </div>
                        <?php endif; ?>
                    </td>
                    <td style="padding: 1rem; font-weight: 600;"><?php echo e($product->title); ?></td>
                    <td style="padding: 1rem;"><?php echo e($product->category->name); ?></td>
                    <td style="padding: 1rem;">
                        <?php if($product->discount_price): ?>
                        <span style="text-decoration: line-through; color: #999; font-size: 0.8rem;">PKR <?php echo e($product->price); ?></span>
                        <span style="color: var(--primary-red); font-weight:600;">PKR <?php echo e($product->discount_price); ?></span>
                        <?php else: ?>
                        <span>PKR <?php echo e($product->price); ?></span>
                        <?php endif; ?>
                    </td>
                    <td style="padding: 1rem;"><?php echo e($product->stock_quantity); ?></td>
                    <td style="padding: 1rem;">
                        <span style="padding: 4px 10px; border-radius: 20px; font-size: 0.8rem; background: <?php echo e($product->status == 'in_stock' ? '#d4edda; color: #155724;' : '#f8d7da; color: #721c24;'); ?>">
                            <?php echo e(str_replace('_', ' ', ucfirst($product->status))); ?>

                        </span>
                    </td>
                    <td style="padding: 1rem;">
                        <a href="<?php echo e(route('admin.products.edit', $product->id)); ?>" class="action-btn btn-edit">
                            <i class="fas fa-edit"></i>
                        </a>
                        <form action="<?php echo e(route('admin.products.destroy', $product->id)); ?>" method="POST" style="display:inline;" onsubmit="return confirm('Delete product?')">
                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="action-btn btn-delete">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" style="padding: 2rem; text-align: center; color: #666;">No products found</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <div class="pagination">
        <?php echo e($products->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Projects\Planters\back\resources\views/admin/products/index.blade.php ENDPATH**/ ?>