<?php $__env->startSection('title', 'Manage Pest Categories'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h2 style="font-size: 1.2rem;">Pest Categories</h2>
        <button class="btn btn-primary" onclick="openPestCategoryModal()">
            <i class="fas fa-plus"></i> Add Category
        </button>
    </div>

    <?php if(session('success')): ?>
    <div style="background: #d4edda; color: #155724; padding: 1rem; border-radius: 6px; margin-bottom: 1.5rem;">
        <?php echo e(session('success')); ?>

    </div>
    <?php endif; ?>

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Image</th>
                    <th>Name</th>
                    <th>Slug</th>
                    <th>Icon</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td>
                        <?php if($category->image): ?>
                        <img src="/<?php echo e($category->image->path); ?>" style="width: 50px; height: 50px; object-fit: cover; border-radius: 8px;">
                        <?php else: ?>
                        <div style="width: 50px; height: 50px; background: #f1f1f1; border-radius: 8px; display: flex; align-items:center; justify-content:center;">
                            <i class="fas fa-image" style="color:#ccc;"></i>
                        </div>
                        <?php endif; ?>
                    </td>
                    <td style="font-weight: 600;"><?php echo e($category->name); ?></td>
                    <td><?php echo e($category->slug); ?></td>
                    <td><i class="<?php echo e($category->icon); ?>"></i> <?php echo e($category->icon); ?></td>
                    <td>
                        <div style="display: flex; gap: 8px;">
                            <button class="action-btn btn-edit" onclick="editPestCategory(<?php echo e(json_encode($category)); ?>)">
                                <i class="fas fa-edit"></i>
                            </button>
                            <form action="<?php echo e(route('admin.pest-categories.destroy', $category->id)); ?>" method="POST" style="display:inline;" onsubmit="return confirm('Delete category?')">
                                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="action-btn btn-delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" style="padding: 2rem; text-align: center; color: #666;">No pest categories found</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <div class="pagination">
        <?php echo e($categories->links()); ?>

    </div>
</div>

<!-- Pest Category CRUD Modal -->
<div id="pestCategoryModal" class="modal">
    <div class="modal-content" style="max-width: 800px; padding: 0; border-radius: 20px; overflow: hidden;">
        <div class="modal-header" style="background: #f8fafc; padding: 1.5rem 2rem; border-bottom: 1px solid #edf2f7; display: flex; justify-content: space-between; align-items: center;">
            <h3 id="pestCategoryModalTitle" style="margin:0; font-size: 1.25rem;">Add Pest Category</h3>
            <button type="button" class="btn btn-secondary" onclick="closeModal('pestCategoryModal')" style="padding: 0.5rem 1rem;">
                <i class="fas fa-times"></i>
            </button>
        </div>

        <form id="pestCategoryForm" action="<?php echo e(route('admin.pest-categories.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="_method" id="pestCategoryMethod" value="POST">

            <div style="padding: 2rem; max-height: 70vh; overflow-y: auto;">
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 2rem; margin-bottom: 2rem;">
                    <div class="form-group">
                        <label style="font-weight: 700; color: #4a5568; margin-bottom: 0.5rem; display: block;">Category Name</label>
                        <input type="text" name="name" id="pcat_name" placeholder="E.g. Crawling Pests" required style="width: 100%;">
                    </div>
                    <div class="form-group">
                        <label style="font-weight: 700; color: #4a5568; margin-bottom: 0.5rem; display: block;">Slug (Optional)</label>
                        <input type="text" name="slug" id="pcat_slug" placeholder="crawling-pests" style="width: 100%;">
                    </div>
                </div>

                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 2rem; margin-bottom: 2rem;">
                    <div class="form-group">
                        <label style="font-weight: 700; color: #4a5568; margin-bottom: 0.5rem; display: block;">Icon Class (Optional)</label>
                        <input type="text" name="icon" id="pcat_icon" placeholder="fas fa-bug" style="width: 100%;">
                    </div>
                    <div class="form-group">
                        <label style="font-weight: 700; color: #4a5568; margin-bottom: 0.5rem; display: block;">Category Image</label>
                        <div style="display:flex; gap: 15px; align-items: center;">
                            <input type="hidden" name="image_id" id="pcat_image_id">
                            <div id="pcat_image_preview" style="width: 100px; height: 100px; background: #f8fafc; border-radius: 15px; border: 2px dashed #edf2f7; display: flex; align-items:center; justify-content:center; overflow:hidden; cursor: pointer;" onclick="openPicker('single', 'pcat_image_id', 'pcat_image_preview')">
                                <i class="fas fa-image" style="font-size: 2rem; color:#cbd5e0;"></i>
                            </div>
                            <button type="button" class="btn btn-secondary btn-sm" onclick="openPicker('single', 'pcat_image_id', 'pcat_image_preview')">
                                <i class="fas fa-images"></i> Browse
                            </button>
                        </div>
                    </div>
                </div>

                <div class="form-group" style="margin-bottom: 2rem;">
                    <label style="font-weight: 700; color: #4a5568; margin-bottom: 0.5rem; display: block;">Description</label>
                    <textarea name="description" id="pcat_description" style="min-height: 100px; width: 100%;" placeholder="Describe this category..."></textarea>
                </div>
            </div>

            <div class="modal-footer" style="padding: 1.5rem 2rem; background: #f8fafc; border-top: 1px solid #edf2f7; display:flex; justify-content: flex-end; gap: 12px;">
                <button type="button" class="btn btn-secondary" onclick="closeModal('pestCategoryModal')">Cancel</button>
                <button type="submit" class="btn btn-primary" style="padding-left: 2rem; padding-right: 2rem;">
                    <i class="fas fa-save"></i> Save Category
                </button>
            </div>
        </form>
    </div>
</div>

<?php echo $__env->make('admin.partials.picker-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    function openPestCategoryModal() {
        document.getElementById('pestCategoryModalTitle').innerText = 'Add Pest Category';
        document.getElementById('pestCategoryForm').action = "<?php echo e(route('admin.pest-categories.store')); ?>";
        document.getElementById('pestCategoryMethod').value = 'POST';
        document.getElementById('pestCategoryForm').reset();
        document.getElementById('pcat_image_preview').innerHTML = '<i class="fas fa-image" style="font-size: 2rem; color:#cbd5e0;"></i>';
        document.getElementById('pcat_image_id').value = '';
        openModal('pestCategoryModal');
    }

    function editPestCategory(category) {
        document.getElementById('pestCategoryModalTitle').innerText = 'Edit Pest Category';
        document.getElementById('pestCategoryForm').action = "<?php echo e(url('admin/pest-categories')); ?>/" + category.id;
        document.getElementById('pestCategoryMethod').value = 'PUT';

        document.getElementById('pcat_name').value = category.name;
        document.getElementById('pcat_slug').value = category.slug;
        document.getElementById('pcat_icon').value = category.icon;
        document.getElementById('pcat_image_id').value = category.image_id;
        document.getElementById('pcat_description').value = category.description;

        if (category.image) {
            document.getElementById('pcat_image_preview').innerHTML = `<img src="/${category.image.path}" style="width:100%; height:100%; object-fit:cover;">`;
        } else {
            document.getElementById('pcat_image_preview').innerHTML = '<i class="fas fa-image" style="font-size: 2rem; color:#cbd5e0;"></i>';
        }

        openModal('pestCategoryModal');
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Projects\Planters\back\resources\views/admin/pest-categories/index.blade.php ENDPATH**/ ?>