@extends('layouts.admin')

@section('title', 'Why Choose Us Cards')
@section('page_title', 'Feature Cards')

@section('content')
<div class="card">
    <div class="card-header">
        <h2>Feature Cards List</h2>
        <div style="display: flex; gap: 10px;">
            <a href="{{ route('admin.pages.why-choose-us') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to Section
            </a>
            <a href="{{ route('admin.why-choose-us.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add New Card
            </a>
        </div>
    </div>

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Icon</th>
                    <th>Heading</th>
                    <th>Paragraph</th>
                    <th style="text-align: right;">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($cards as $card)
                <tr>
                    <td style="width: 60px; text-align: center;">
                        <i class="{{ $card->icon }} fa-2x" style="color: var(--primary-red);"></i>
                    </td>
                    <td style="font-weight: 600;">{{ $card->heading }}</td>
                    <td>
                        <p style="max-width: 400px; font-size: 0.85rem; color: #64748b; margin: 0;">{{ Str::limit($card->paragraph, 100) }}</p>
                    </td>
                    <td>
                        <div style="display: flex; gap: 8px; justify-content: flex-end;">
                            <a href="{{ route('admin.why-choose-us.edit', $card) }}" class="action-btn btn-edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="{{ route('admin.why-choose-us.destroy', $card) }}" method="POST" onsubmit="return confirm('Are you sure?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="action-btn btn-delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="4" style="text-align: center; padding: 3rem;">No feature cards found.</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
