@extends('layouts.admin')

@section('title', 'Edit Feature Card')
@section('page_title', 'Update Feature Card')

@section('content')
<div class="card" style="max-width: 600px; margin: 0 auto;">
    <div class="card-header">
        <h2>Edit Feature Card</h2>
    </div>
    <form action="{{ route('admin.why-choose-us.update', $card) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="form-group">
            <label>Icon (FontAwesome class)</label>
            <input type="text" name="icon" class="form-control" value="{{ old('icon', $card->icon) }}" required>
        </div>
        <div class="form-group">
            <label>Heading</label>
            <input type="text" name="heading" class="form-control" value="{{ old('heading', $card->heading) }}" required>
        </div>
        <div class="form-group">
            <label>Paragraph</label>
            <textarea name="paragraph" class="form-control" rows="4">{{ old('paragraph', $card->paragraph) }}</textarea>
        </div>

        <div style="margin-top: 2rem; display: flex; gap: 10px; justify-content: flex-end;">
            <a href="{{ route('admin.why-choose-us.index') }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Update Card
            </button>
        </div>
    </form>
</div>
@endsection
