@extends('layouts.admin')

@section('title', 'Add Feature Card')
@section('page_title', 'New Feature Card')

@section('content')
<div class="card" style="max-width: 600px; margin: 0 auto;">
    <div class="card-header">
        <h2>Add New Feature Card</h2>
    </div>
    <form action="{{ route('admin.why-choose-us.store') }}" method="POST">
        @csrf
        <div class="form-group">
            <label>Icon (FontAwesome class)</label>
            <input type="text" name="icon" class="form-control" placeholder="fas fa-shield-alt" required>
        </div>
        <div class="form-group">
            <label>Heading</label>
            <input type="text" name="heading" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Paragraph</label>
            <textarea name="paragraph" class="form-control" rows="4"></textarea>
        </div>

        <div style="margin-top: 2rem; display: flex; gap: 10px; justify-content: flex-end;">
            <a href="{{ route('admin.why-choose-us.index') }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Save Card
            </button>
        </div>
    </form>
</div>
@endsection
