@extends('layouts.admin')

@section('title', 'Manage Tags')

@section('content')
<div class="card">
    <div class="card-header">
        <h2 style="font-size: 1.2rem;">Tags</h2>
        <button class="btn btn-primary" onclick="openTagModal()">
            <i class="fas fa-plus"></i> Add Tag
        </button>
    </div>

    @if(session('success'))
    <div style="background: #d4edda; color: #155724; padding: 1rem; border-radius: 6px; margin-bottom: 1.5rem;">
        {{ session('success') }}
    </div>
    @endif

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Icon</th>
                    <th>Name</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($tags as $tag)
                <tr>
                    <td><i class="{{ $tag->icon }}"></i></td>
                    <td style="font-weight: 600;">{{ $tag->name }}</td>
                    <td>
                        <button class="action-btn btn-edit" onclick="editTag({{ json_encode($tag) }})">
                            <i class="fas fa-edit"></i>
                        </button>
                        <form action="{{ route('admin.tags.destroy', $tag->id) }}" method="POST" style="display:inline;" onsubmit="return confirm('Delete tag?')">
                            @csrf @method('DELETE')
                            <button type="submit" class="action-btn btn-delete">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="3" style="padding: 2rem; text-align: center; color: #666;">No tags found</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    <div class="pagination">
        {{ $tags->links() }}
    </div>
</div>

<!-- Tag Modal -->
<div id="tagModal" class="modal">
    <div class="modal-content" style="max-width: 500px;">
        <h3 id="tagModalTitle">Add Tag</h3>
        <form id="tagForm" action="{{ route('admin.tags.store') }}" method="POST">
            @csrf
            <input type="hidden" name="_method" id="tagMethod" value="POST">

            <div class="form-group">
                <label>Name</label>
                <input type="text" name="name" id="tag_name" required>
            </div>

            <div class="form-group">
                <label>Icon Class (Optional)</label>
                <input type="text" name="icon" id="tag_icon" placeholder="fas fa-tag">
            </div>

            <div style="display:flex; gap: 10px; justify-content: flex-end;">
                <button type="button" class="btn btn-secondary" onclick="closeModal('tagModal')">Cancel</button>
                <button type="submit" class="btn btn-primary">Save Tag</button>
            </div>
        </form>
    </div>
</div>

@endsection

@section('scripts')
<script>
    function openTagModal() {
        document.getElementById('tagModalTitle').innerText = 'Add Tag';
        document.getElementById('tagForm').action = "{{ route('admin.tags.store') }}";
        document.getElementById('tagMethod').value = 'POST';
        document.getElementById('tagForm').reset();
        openModal('tagModal');
    }

    function editTag(tag) {
        document.getElementById('tagModalTitle').innerText = 'Edit Tag';
        document.getElementById('tagForm').action = "{{ url('admin/tags') }}/" + tag.id;
        document.getElementById('tagMethod').value = 'PUT';

        document.getElementById('tag_name').value = tag.name;
        document.getElementById('tag_icon').value = tag.icon;

        openModal('tagModal');
    }
</script>
@endsection