{{-- Quarantine Fumigation --}}
<div class="section-container">
    <h3 class="section-title"><i class="fas fa-ship"></i> Main Section (Right Image)</h3>
    <div class="grid-2">
        <div>
            <div class="form-group">
                <label>Tag</label>
                <input type="text" name="section1_tag" class="form-control" value="{{ $detail->section1_tag }}">
            </div>
            <div class="form-group">
                <label>Heading</label>
                <input type="text" name="section1_heading" class="form-control" value="{{ $detail->section1_heading }}">
            </div>
            <div class="form-group">
                <label>Description</label>
                <textarea name="section1_description" class="form-control" rows="4">{{ $detail->section1_description }}</textarea>
            </div>
        </div>
        <div>
            <label>Right-side Image</label>
            <div class="image-preview-container" style="height: 200px;" onclick="openCMSPicker('section1_image1_id', 'section1_image1_prev')">
                <input type="hidden" name="section1_image1_id" id="section1_image1_id" value="{{ $detail->section1_image1_id }}">
                <div id="section1_image1_prev">
                    @if($detail->section1Image1)
                        <img src="{{ asset($detail->section1Image1->path) }}">
                    @else
                        <div class="upload-placeholder">
                            <i class="fas fa-image"></i>
                            <p>Select Image</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<div class="section-container">
    <h3 class="section-title"><i class="fas fa-layer-group"></i> Second Main Section (Left Image)</h3>
    <div class="grid-2">
        <div>
            <label>Left-side Image</label>
            <div class="image-preview-container" style="height: 200px;" onclick="openCMSPicker('section2_image_id', 'section2_image_prev')">
                <input type="hidden" name="section2_image_id" id="section2_image_id" value="{{ $detail->section2_image_id }}">
                <div id="section2_image_prev">
                    @if($detail->section2Image)
                        <img src="{{ asset($detail->section2Image->path) }}">
                    @else
                        <div class="upload-placeholder">
                            <i class="fas fa-image"></i>
                            <p>Select Image</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
        <div>
            <div class="form-group">
                <label>Tag</label>
                <input type="text" name="section2_tag" class="form-control" value="{{ $detail->section2_tag }}">
            </div>
            <div class="form-group">
                <label>Heading</label>
                <input type="text" name="section2_heading" class="form-control" value="{{ $detail->section2_heading }}">
            </div>
            <div class="form-group">
                <label>Description</label>
                <textarea name="section2_description" class="form-control" rows="4">{{ $detail->section2_description }}</textarea>
            </div>
        </div>
    </div>
</div>

<div class="section-container">
    <h3 class="section-title"><i class="fas fa-cogs"></i> How it Works</h3>
    <div class="grid-2">
        <div class="form-group">
            <label>Section Heading</label>
            <input type="text" name="how_it_works_heading" class="form-control" value="{{ $detail->how_it_works_heading }}">
        </div>
        <div class="form-group">
            <label>Section Paragraph</label>
            <textarea name="how_it_works_description" class="form-control" rows="2">{{ $detail->how_it_works_description }}</textarea>
        </div>
    </div>
    
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
        <h4 style="font-size: 0.9rem; font-weight: 600;">Process Flow (Exactly 4 Steps)</h4>
        <button type="button" class="btn btn-secondary btn-sm" onclick="addItem('process_flow', 'process-flow-container')">
            <i class="fas fa-plus"></i> Add Step
        </button>
    </div>

    <div id="process-flow-container">
        @foreach($detail->items->where('type', 'process_flow') as $index => $item)
            <div class="card-item">
                <i class="fas fa-trash remove-item" onclick="this.parentElement.remove()"></i>
                <div class="grid-2">
                    <div class="form-group">
                        <label>Icon Class</label>
                        <input type="text" name="items[process_flow][{{ $index }}][icon]" class="form-control" value="{{ $item->icon }}">
                    </div>
                    <div class="form-group">
                        <label>Heading</label>
                        <input type="text" name="items[process_flow][{{ $index }}][title]" class="form-control" value="{{ $item->title }}">
                    </div>
                </div>
                <div class="form-group">
                    <label>Paragraph</label>
                    <textarea name="items[process_flow][{{ $index }}][description]" class="form-control" rows="2">{{ $item->description }}</textarea>
                </div>
            </div>
        @endforeach
    </div>
</div>

<div class="section-container">
    <h3 class="section-title"><i class="fas fa-chart-line"></i> Why Invest Section</h3>
    <div class="grid-2">
        <div class="form-group">
            <label>Section Heading</label>
            <input type="text" name="why_invest_heading" class="form-control" value="{{ $detail->why_invest_heading }}">
        </div>
        <div class="form-group">
            <label>Section Paragraph</label>
            <textarea name="why_invest_description" class="form-control" rows="2">{{ $detail->why_invest_description }}</textarea>
        </div>
    </div>
    
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
        <h4 style="font-size: 0.9rem; font-weight: 600;">Why Invest Cards</h4>
        <button type="button" class="btn btn-secondary btn-sm" onclick="addItem('why_invest', 'why-invest-container')">
            <i class="fas fa-plus"></i> Add Card
        </button>
    </div>

    <div id="why-invest-container">
        @foreach($detail->items->where('type', 'why_invest') as $index => $item)
            <div class="card-item">
                <i class="fas fa-trash remove-item" onclick="this.parentElement.remove()"></i>
                <div class="grid-2">
                    <div class="form-group">
                        <label>Icon</label>
                        <input type="text" name="items[why_invest][{{ $index }}][icon]" class="form-control" value="{{ $item->icon }}">
                    </div>
                    <div class="form-group">
                        <label>Heading</label>
                        <input type="text" name="items[why_invest][{{ $index }}][title]" class="form-control" value="{{ $item->title }}">
                    </div>
                </div>
                <div class="form-group">
                    <label>Paragraph</label>
                    <textarea name="items[why_invest][{{ $index }}][description]" class="form-control" rows="2">{{ $item->description }}</textarea>
                </div>
            </div>
        @endforeach
    </div>
</div>
