@extends('layouts.admin')

@section('title', 'Service Categories')
@section('page_title', 'Manage Service Categories')

@section('content')
<div class="card">
    <div class="card-header">
        <h2>Service Categories</h2>
        <a href="{{ route('admin.service-categories.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add New Category
        </a>
    </div>

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Icon</th>
                    <th>Name</th>
                    <th>Slug</th>
                    <th>Top</th>
                    <th>SEO Title</th>
                    <th style="text-align: right;">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($categories as $category)
                <tr>
                    <td style="width: 60px; text-align: center;">
                        @if($category->image)
                            <img src="{{ asset($category->image->path) }}" alt="{{ $category->name }}" style="width: 50px; height: 50px; object-fit: cover; border-radius: 8px; border: 2px solid #edf2f7;">
                        @elseif($category->icon)
                            <i class="{{ $category->icon }} fa-lg" style="color: var(--primary-red);"></i>
                        @else
                            <i class="fas fa-briefcase fa-lg" style="color: #94a3b8;"></i>
                        @endif
                    </td>
                    <td style="font-weight: 700;">{{ $category->name }}</td>
                    <td><code>{{ $category->slug }}</code></td>
                    <td style="text-align: center;">
                        @if($category->is_top)
                            <span class="badge badge-success">YES</span>
                        @else
                            <span class="badge badge-secondary" style="background: #eee; color: #666;">No</span>
                        @endif
                    </td>
                    <td style="font-size: 0.85rem; color: #64748b;">{{ Str::limit($category->meta_title, 40) }}</td>
                    <td>
                        <div style="display: flex; gap: 8px; justify-content: flex-end;">
                            <a href="{{ route('admin.service-categories.details.edit', $category->id) }}" class="btn btn-secondary btn-sm" title="Manage Details">
                                <i class="fas fa-list-alt"></i> Details
                            </a>
                            <a href="{{ route('admin.service-categories.edit', $category) }}" class="action-btn btn-edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="{{ route('admin.service-categories.destroy', $category) }}" method="POST" onsubmit="return confirm('Delete this category and all its services?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="action-btn btn-delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" style="text-align: center; padding: 3rem; color: #94a3b8;">
                        No service categories found.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
