@extends('layouts.admin')

@section('title', 'Manage Details - ' . $category->name)
@section('page_title', 'Manage Details: ' . $category->name)

@section('styles')
<style>
    .section-container {
        background: #fff;
        border-radius: 12px;
        padding: 2rem;
        margin-bottom: 2rem;
        box-shadow: 0 4px 6px rgba(0,0,0,0.05);
        border: 1px solid #edf2f7;
    }
    .section-title {
        font-size: 1.1rem;
        font-weight: 700;
        color: #2d3748;
        margin-bottom: 1.5rem;
        padding-bottom: 1rem;
        border-bottom: 2px solid var(--primary-red);
        display: inline-block;
    }
    .grid-2 { 
        display: grid; 
        grid-template-columns: 1fr 1fr; 
        gap: 20px; 
    }
    .grid-2 > * { min-width: 0; }
    @media (max-width: 992px) {
        .grid-2 { grid-template-columns: 1fr; }
    }
    .image-preview-container {
        width: 100%;
        height: 150px;
        background: #f8fafc;
        border: 2px dashed #cbd5e1;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        position: relative;
        overflow: hidden;
    }
    .image-preview-container img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    .image-preview-container .upload-placeholder {
        text-align: center;
        color: #64748b;
    }
    .card-item {
        background: #f8fafc;
        border: 1px solid #e2e8f0;
        border-radius: 8px;
        padding: 1.5rem;
        margin-bottom: 1rem;
        position: relative;
    }
    .remove-item {
        position: absolute;
        top: 10px;
        right: 10px;
        color: var(--primary-red);
        cursor: pointer;
    }
    .grid-2 > * {
        min-width: 0;
    }
    /* CKEditor Width Fix */
    .ck-editor__editable {
        min-height: 200px;
    }
    .ck.ck-editor {
        max-width: 100% !important;
    }
</style>
@endsection

@section('content')
<form action="{{ route('admin.service-categories.details.update', $category->id) }}" method="POST">
    @csrf

    {{-- Hero Section --}}
    <div class="section-container">
        <h3 class="section-title"><i class="fas fa-rocket"></i> Hero Section</h3>
        <div class="grid-2">
            <div class="form-group">
                <label>Heading</label>
                <input type="text" name="hero_heading" class="form-control" value="{{ $detail->hero_heading }}">
            </div>
            <div class="form-group">
                <label>Background Image</label>
                <div class="image-preview-container" onclick="openCMSPicker('hero_image_id', 'hero_image_preview')">
                    <input type="hidden" name="hero_image_id" id="hero_image_id" value="{{ $detail->hero_image_id }}">
                    <div id="hero_image_preview">
                        @if($detail->heroImage)
                            <img src="{{ asset($detail->heroImage->path) }}">
                        @else
                            <div class="upload-placeholder">
                                <i class="fas fa-cloud-upload-alt fa-2x"></i>
                                <p>Select Background</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <div class="form-group">
            <label>Description</label>
            <textarea name="hero_description" class="form-control" rows="3">{{ $detail->hero_description }}</textarea>
        </div>
        <div class="grid-2">
            <div class="form-group">
                <label>CTA 1 Text</label>
                <input type="text" name="hero_cta1_text" class="form-control" value="{{ $detail->hero_cta1_text }}">
            </div>
            <div class="form-group">
                <label>CTA 1 URL</label>
                <input type="text" name="hero_cta1_url" class="form-control" value="{{ $detail->hero_cta1_url }}">
            </div>
        </div>
        <div class="grid-2">
            <div class="form-group">
                <label>CTA 2 Text</label>
                <input type="text" name="hero_cta2_text" class="form-control" value="{{ $detail->hero_cta2_text }}">
            </div>
            <div class="form-group">
                <label>CTA 2 URL</label>
                <input type="text" name="hero_cta2_url" class="form-control" value="{{ $detail->hero_cta2_url }}">
            </div>
        </div>
    </div>

    @if($category->slug == 'stored-products-test' || $category->slug == 'stored-products-treatment')
        @include('admin.service-categories.partials.stored_products')
    @elseif($category->slug == 'quarantine-fumigation')
        @include('admin.service-categories.partials.quarantine_fumigation')
    @elseif($category->slug == 'residential-services')
        @include('admin.service-categories.partials.residential_services')
    @elseif($category->slug == 'commercial-services')
        @include('admin.service-categories.partials.commercial_services')
    @endif

    {{-- Banner Section --}}
    <div class="section-container">
        <h3 class="section-title"><i class="fas fa-flag"></i> Banner Section</h3>
        <div class="form-group">
            <label>Heading</label>
            <input type="text" name="banner_heading" class="form-control" value="{{ $detail->banner_heading }}">
        </div>
        <div class="form-group">
            <label>Description</label>
            <textarea name="banner_description" class="form-control" rows="3">{{ $detail->banner_description }}</textarea>
        </div>
        <div class="grid-2">
            <div class="form-group">
                <label>Button 1 Text</label>
                <input type="text" name="banner_b1_text" class="form-control" value="{{ $detail->banner_b1_text }}">
            </div>
            <div class="form-group">
                <label>Button 1 URL</label>
                <input type="text" name="banner_b1_url" class="form-control" value="{{ $detail->banner_b1_url }}">
            </div>
        </div>
        <div class="grid-2">
            <div class="form-group">
                <label>Button 2 Text</label>
                <input type="text" name="banner_b2_text" class="form-control" value="{{ $detail->banner_b2_text }}">
            </div>
            <div class="form-group">
                <label>Button 2 URL</label>
                <input type="text" name="banner_b2_url" class="form-control" value="{{ $detail->banner_b2_url }}">
            </div>
        </div>
    </div>

    <div style="position: sticky; bottom: 20px; background: white; padding: 1rem; border-radius: 12px; box-shadow: 0 -4px 10px rgba(0,0,0,0.1); display: flex; justify-content: flex-end; z-index: 100;">
        <button type="submit" class="btn btn-primary" style="padding: 0.8rem 3rem;">SAVE ALL CHANGES</button>
    </div>
</form>
@endsection

@section('scripts')
<script src="https://cdn.ckeditor.com/ckeditor5/40.0.0/classic/ckeditor.js"></script>
<script>
    function initializeCKEditor(selector) {
        document.querySelectorAll(selector).forEach(el => {
            ClassicEditor.create(el).catch(error => console.error(error));
        });
    }
    initializeCKEditor('.rich-editor');

    let itemCounts = {
        why_invest: {{ $detail->items->where('type', 'why_invest')->count() }},
        process_flow: {{ $detail->items->where('type', 'process_flow')->count() }},
        common_pest: {{ $detail->items->where('type', 'common_pest')->count() }},
        tracking_step: {{ $detail->items->where('type', 'tracking_step')->count() }}
    };

    function addItem(type, containerId) {
        const container = document.getElementById(containerId);
        const count = itemCounts[type];
        let html = '';

        if (type === 'why_invest' || type === 'process_flow' || type === 'tracking_step') {
            html = `
                <div class="card-item">
                    <i class="fas fa-trash remove-item" onclick="this.parentElement.remove()"></i>
                    <div class="grid-2">
                        <div class="form-group">
                            <label>Icon Class (e.g. fas fa-check)</label>
                            <input type="text" name="items[${type}][${count}][icon]" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Title</label>
                            <input type="text" name="items[${type}][${count}][title]" class="form-control">
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Description</label>
                        <textarea name="items[${type}][${count}][description]" class="form-control" rows="2"></textarea>
                    </div>
                    <input type="hidden" name="items[${type}][${count}][sort_order]" value="${count}">
                </div>
            `;
        } else if (type === 'common_pest') {
            html = `
                <div class="card-item">
                    <i class="fas fa-trash remove-item" onclick="this.parentElement.remove()"></i>
                    <div class="grid-2">
                        <div class="form-group">
                            <label>Image</label>
                            <div class="image-preview-container" onclick="openCMSPicker('pest_img_${count}', 'pest_prev_${count}')">
                                <input type="hidden" name="items[${type}][${count}][image_id]" id="pest_img_${count}">
                                <div id="pest_prev_${count}">
                                    <div class="upload-placeholder">
                                        <i class="fas fa-cloud-upload-alt"></i>
                                        <p>Select Image</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>Heading</label>
                            <input type="text" name="items[${type}][${count}][title]" class="form-control">
                            <div class="form-group" style="margin-top:10px;">
                                <label>Description</label>
                                <textarea name="items[${type}][${count}][description]" class="form-control" rows="3"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            `;
        }

        container.insertAdjacentHTML('beforeend', html);
        itemCounts[type]++;
    }

    function openCMSPicker(inputId, previewId) {
        if (typeof openPicker === 'function') {
            openPicker('single', inputId, previewId, (selected) => {
                const img = selected[0];
                document.getElementById(inputId).value = img.id; // Store ID not path for DB foreign key
                const preview = document.getElementById(previewId);
                preview.innerHTML = `<img src="/${img.path}" style="width:100%; height:100%; object-fit:cover; border-radius:8px;">`;
            });
        }
    }
</script>
@endsection
