@extends('layouts.admin')

@section('title', 'Edit Service Area')
@section('page_title', 'Update Service Area')

@section('content')
<div class="card" style="max-width: 900px; margin: 0 auto;">
    <div class="card-header">
        <h2>Editing Area: {{ $service_area->name }}</h2>
    </div>
    <div style="padding: 2rem;">
        <form action="{{ route('admin.service-areas.update', $service_area) }}" method="POST">
            @csrf
            @method('PUT')
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                <div class="form-group">
                    <label>Area Name <span style="color: red;">*</span></label>
                    <input type="text" name="name" class="form-control" value="{{ $service_area->name }}" required>
                </div>
                <div class="form-group">
                    <label>Icon Class (FontAwesome)</label>
                    <input type="text" name="icon" class="form-control" value="{{ $service_area->icon }}">
                </div>
            </div>

            <div class="form-group">
                <label>Slug</label>
                <input type="text" name="slug" class="form-control" value="{{ $service_area->slug }}">
            </div>

            <div class="form-group">
                <label>Introduction / Short Description</label>
                <textarea name="short_description" class="form-control" rows="3">{{ $service_area->short_description }}</textarea>
            </div>

            <div style="margin-top: 2rem; padding-top: 1rem; border-top: 1px solid #edf2f7;">
                <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem;">
                    <h4 style="font-size: 0.85rem; text-transform: uppercase; color: #64748b; margin: 0;">Area Details (Title & Description)</h4>
                    <button type="button" class="btn btn-secondary btn-sm" onclick="addDetailRow()">
                        <i class="fas fa-plus"></i> Add Detail
                    </button>
                </div>
                
                <div id="details-container">
                    @forelse($service_area->details as $index => $detail)
                        <div class="detail-row card" style="padding: 1rem; margin-bottom: 1rem; background: #fff; border: 1px solid #e2e8f0; position: relative;">
                            <button type="button" class="btn btn-delete btn-sm" style="position: absolute; top: 10px; right: 10px; width: 30px; height: 30px; padding: 0;" onclick="this.closest('.detail-row').remove()">
                                <i class="fas fa-times"></i>
                            </button>
                            <div class="form-group" style="margin-bottom: 1rem;">
                                <label>Title</label>
                                <input type="text" name="details[{{ $index }}][title]" class="form-control" value="{{ $detail->title }}" required>
                            </div>
                            <div class="form-group" style="margin-bottom: 0;">
                                <label>Description</label>
                                <textarea name="details[{{ $index }}][description]" class="form-control" rows="3">{{ $detail->description }}</textarea>
                            </div>
                        </div>
                    @empty
                        <p id="no-details" style="color: #64748b; text-align: center; padding: 1rem;">No details added yet.</p>
                    @endforelse
                </div>
            </div>

            <!-- SEO Section -->
            <div style="margin-top: 2rem; padding-top: 1rem; border-top: 1px solid #edf2f7;">
                <h4 style="font-size: 0.85rem; text-transform: uppercase; color: #64748b; margin-bottom: 1rem;">SEO Meta Information</h4>
                <div class="form-group">
                    <label>Meta Title</label>
                    <input type="text" name="meta_title" class="form-control" value="{{ $service_area->meta_title }}">
                </div>
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                    <div class="form-group">
                        <label>Meta Keywords</label>
                        <textarea name="meta_keywords" class="form-control" rows="2">{{ $service_area->meta_keywords }}</textarea>
                    </div>
                    <div class="form-group">
                        <label>Meta Description</label>
                        <textarea name="meta_description" class="form-control" rows="2">{{ $service_area->meta_description }}</textarea>
                    </div>
                </div>
            </div>

            <div style="text-align: right; margin-top: 2rem; padding-top: 1.5rem; border-top: 1px solid #eee;">
                <a href="{{ route('admin.service-areas.index') }}" class="btn btn-secondary" style="margin-right: 10px;">Cancel</a>
                <button type="submit" class="btn btn-primary" style="padding: 0.7rem 2.5rem; font-weight: 700;">
                    UPDATE SERVICE AREA
                </button>
            </div>
        </form>
    </div>
</div>

@section('scripts')
<script>
    let detailCount = {{ count($service_area->details) }};

    function addDetailRow() {
        const noDetails = document.getElementById('no-details');
        if (noDetails) noDetails.remove();

        const container = document.getElementById('details-container');
        const html = `
            <div class="detail-row card" style="padding: 1rem; margin-bottom: 1rem; background: #fff; border: 1px solid #e2e8f0; position: relative;">
                <button type="button" class="btn btn-delete btn-sm" style="position: absolute; top: 10px; right: 10px; width: 30px; height: 30px; padding: 0;" onclick="this.closest('.detail-row').remove()">
                    <i class="fas fa-times"></i>
                </button>
                <div class="form-group" style="margin-bottom: 1rem;">
                    <label>Title</label>
                    <input type="text" name="details[${detailCount}][title]" class="form-control" required>
                </div>
                <div class="form-group" style="margin-bottom: 0;">
                    <label>Description</label>
                    <textarea name="details[${detailCount}][description]" class="form-control" rows="3"></textarea>
                </div>
            </div>
        `;
        container.insertAdjacentHTML('beforeend', html);
        detailCount++;
    }
</script>
@endsection
@endsection
