@extends('layouts.admin')

@section('title', 'Registrations')
@section('page_title', 'Manage Registrations')

@section('content')
<div class="card">
    <div class="card-header">
        <h2>Registrations List</h2>
        <a href="{{ route('admin.registrations.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add New Registration
        </a>
    </div>

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Image</th>
                    <th>Name</th>
                    <th>Slug</th>
                    <th>Created At</th>
                    <th style="text-align: right;">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($registrations as $item)
                <tr>
                    <td style="width: 80px;">
                        <img src="{{ $item->imageFile ? asset($item->imageFile->path) : 'https://placehold.co/50x50' }}" style="width: 50px; height: 50px; border-radius: 8px; object-fit: cover; border: 1px solid #eee;">
                    </td>
                    <td style="font-weight: 600;">{{ $item->name }}</td>
                    <td><code>{{ $item->slug }}</code></td>
                    <td>{{ $item->created_at->format('M d, Y') }}</td>
                    <td>
                        <div style="display: flex; gap: 8px; justify-content: flex-end;">
                            <a href="{{ route('admin.registrations.edit', $item) }}" class="action-btn btn-edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="{{ route('admin.registrations.destroy', $item) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this registration?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="action-btn btn-delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" style="text-align: center; padding: 3rem;">
                        <i class="fas fa-id-card" style="font-size: 3rem; color: #e2e8f0; margin-bottom: 1rem; display: block;"></i>
                        No registrations found.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div style="margin-top: 1.5rem;">
        {{ $registrations->links() }}
    </div>
</div>
@endsection