@extends('layouts.admin')

@section('title', 'Change Password')
@section('page_title', 'Security Settings')

@section('content')
<div class="card" style="max-width: 500px; margin: 0 auto;">
    <div class="card-header">
        <h2>Change Password</h2>
    </div>
    <form action="{{ route('admin.profile.password.update') }}" method="POST">
        @csrf
        <div class="form-group">
            <label>Current Password</label>
            <input type="password" name="current_password" class="form-control @error('current_password') is-invalid @enderror" required>
            @error('current_password') <div style="color: var(--primary-red); font-size: 0.8rem; margin-top: 5px;">{{ $message }}</div> @enderror
        </div>

        <div class="form-group">
            <label>New Password</label>
            <input type="password" name="new_password" class="form-control @error('new_password') is-invalid @enderror" required>
            @error('new_password') <div style="color: var(--primary-red); font-size: 0.8rem; margin-top: 5px;">{{ $message }}</div> @enderror
        </div>

        <div class="form-group">
            <label>Confirm New Password</label>
            <input type="password" name="new_password_confirmation" class="form-control" required>
        </div>

        <div style="margin-top: 2rem; text-align: right;">
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-key"></i> Update Password
            </button>
        </div>
    </form>
</div>
@endsection
