@extends('layouts.admin')

@section('title', 'Add Product')

@section('content')
<div class="card">
    <div class="card-header">
        <h2 style="font-size: 1.2rem;">Add New Product</h2>
        <a href="{{ route('admin.products.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back to List
        </a>
    </div>

    @if($errors->any())
    <div style="background: #f8d7da; color: #721c24; padding: 1rem; border-radius: 6px; margin-bottom: 1.5rem;">
        <ul style="margin:0;">
            @foreach($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <form action="{{ route('admin.products.store') }}" method="POST">
        @csrf

        <div style="display: grid; grid-template-columns: 2.2fr 1fr; gap: 2.5rem;">
            <!-- Left Side -->
            <div>
                <div class="form-group">
                    <label>Product Title</label>
                    <input type="text" name="title" id="prod_title" value="{{ old('title') }}" placeholder="Enter product title" required>
                </div>

                <div class="form-group">
                    <label>Slug (Auto-generated if empty)</label>
                    <input type="text" name="slug" id="prod_slug" value="{{ old('slug') }}" placeholder="product-slug">
                </div>

                <div class="form-group">
                    <label>Thumbnail Image</label>
                    <div id="thumb_box" style="width: 100%; height: 200px; background: #f8fafc; border-radius: 15px; border: 2px dashed #edf2f7; display: flex; flex-direction: column; align-items:center; justify-content:center; overflow:hidden; cursor: pointer; transition: 0.3s;" onclick="openPicker('single', 'thumb_id', 'thumb_box')">
                        <i class="fas fa-cloud-upload-alt" style="font-size: 2.5rem; color: #cbd5e0; margin-bottom: 10px;"></i>
                        <span style="color: #718096; font-size: 0.9rem;">Click to select thumbnail</span>
                    </div>
                    <input type="hidden" name="thumbnail_id" id="thumb_id">
                </div>

                <div class="form-group">
                    <label>Product Gallery</label>
                    <div id="gallery_box" style="width: 100%; min-height: 150px; background: #f8fafc; border-radius: 15px; border: 2px dashed #edf2f7; display: flex; flex-wrap: wrap; gap: 10px; padding: 15px; cursor: pointer; transition: 0.3s;" onclick="openPicker('multiple', 'gallery_ids', 'gallery_box')">
                        <div style="width: 100%; text-align: center; color: #718096; display: flex; flex-direction: column; align-items: center; justify-content: center;" id="gallery_placeholder">
                            <i class="fas fa-images" style="font-size: 2.5rem; color: #cbd5e0; margin-bottom: 10px;"></i>
                            <span style="font-size: 0.9rem;">Click to select multiple gallery images</span>
                        </div>
                    </div>
                    <input type="hidden" name="gallery_ids" id="gallery_ids">
                </div>

                <div class="form-group">
                    <label>Short Description</label>
                    <textarea name="short_description" style="min-height: 100px;">{{ old('short_description') }}</textarea>
                </div>

                <div class="form-group">
                    <label>Long Description</label>
                    <textarea name="long_description" id="editor">{{ old('long_description') }}</textarea>
                </div>

                <div class="form-group">
                    <label>How to Use</label>
                    <textarea name="how_to_use" style="min-height: 120px;" placeholder="Instructions for using the product...">{{ old('how_to_use') }}</textarea>
                </div>
            </div>

            <!-- Right Side (Sidebar) -->
            <div>
                <div class="card" style="padding: 1.5rem; border-radius: 15px; margin-bottom: 2rem; position: sticky; top: 20px;">
                    <div class="form-group">
                        <label>Category</label>
                        <select name="category_id" required>
                            <option value="">Select Category</option>
                            @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                        <div class="form-group">
                            <label>Base Price (PKR)</label>
                            <input type="number" step="0.01" name="price" value="{{ old('price') }}" required>
                        </div>
                        <div class="form-group">
                            <label>Discount (PKR)</label>
                            <input type="number" step="0.01" name="discount_price" value="{{ old('discount_price') }}">
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Status</label>
                        <select name="status" id="prod_status">
                            <option value="" disabled selected>Select Product Status</option>

                            <option value="in_stock" {{ old('status') == 'in_stock' ? 'selected' : '' }}>In Stock</option>
                            <option value="out_of_stock" {{ old('status') == 'out_of_stock' ? 'selected' : '' }}>Out of Stock</option>
                        </select>
                    </div>

                    <div class="form-group" id="stock_field">
                        <label>Stock Quantity</label>
                        <input type="number" name="stock_quantity" value="{{ old('stock_quantity', 0) }}">
                    </div>

                    <div class="form-group">
                        <label>Tags</label>
                        <div style="max-height: 250px; overflow-y: auto; padding: 12px; background: #fff; border-radius: 10px; border: 2px solid #edf2f7;">
                            @foreach($tags as $tag)
                            <label style="display:flex; align-items:center; gap: 10px; margin-bottom: 8px; cursor:pointer; font-size: 0.9rem;">
                                <input type="checkbox" name="tag_ids[]" value="{{ $tag->id }}" style="width: auto;">
                                <i class="{{ $tag->icon }}" style="color: #4a5568;"></i> {{ $tag->name }}
                            </label>
                            @endforeach
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary" style="width:100%; padding: 1rem; margin-top: 1rem;">
                        <i class="fas fa-paper-plane"></i> Publish Product
                    </button>
                    <button type="reset" class="btn btn-secondary" style="width:100%; margin-top: 0.5rem;">Reset Form</button>
                </div>
            </div>
        </div>
    </form>
</div>


@endsection

@section('scripts')
<script src="https://cdn.ckeditor.com/ckeditor5/40.0.0/classic/ckeditor.js"></script>
<script>
    ClassicEditor
        .create(document.querySelector('#editor'))
        .catch(error => {
            console.error(error);
        });

    document.getElementById('prod_status').addEventListener('change', function() {
        const stockField = document.getElementById('stock_field');
        if (this.value === 'in_stock') {
            stockField.style.display = 'block';
        } else {
            stockField.style.display = 'none';
        }
    });
</script>
@endsection