@extends('layouts.admin')

@section('title', 'Add Pest')

@section('content')
<div class="card">
    <div class="card-header">
        <h2 style="font-size: 1.2rem;">Add New Pest</h2>
        <a href="{{ route('admin.pests.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back to List
        </a>
    </div>

    @if($errors->any())
    <div style="background: #f8d7da; color: #721c24; padding: 1rem; border-radius: 6px; margin-bottom: 1.5rem;">
        <ul style="margin:0;">
            @foreach($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    <form action="{{ route('admin.pests.store') }}" method="POST">
        @csrf

        <div style="display: grid; grid-template-columns: 2fr 1fr; gap: 2.5rem;">
            <!-- Left Side -->
            <div>
                <div class="form-group">
                    <label>Pest Title</label>
                    <input type="text" name="title" id="pest_title" value="{{ old('title') }}" placeholder="Enter pest title" required>
                </div>

                <div class="form-group">
                    <label>Slug (Auto-generated if empty)</label>
                    <input type="text" name="slug" id="pest_slug" value="{{ old('slug') }}" placeholder="pest-slug">
                </div>

                <div class="form-group">
                    <label>Image</label>
                    <div id="pest_image_box" style="width: 100%; height: 200px; background: #f8fafc; border-radius: 15px; border: 2px dashed #edf2f7; display: flex; flex-direction: column; align-items:center; justify-content:center; overflow:hidden; cursor: pointer; transition: 0.3s;" onclick="openPicker('single', 'pest_image_id', 'pest_image_box')">
                        <i class="fas fa-cloud-upload-alt" style="font-size: 2.5rem; color: #cbd5e0; margin-bottom: 10px;"></i>
                        <span style="color: #718096; font-size: 0.9rem;">Click to select image</span>
                    </div>
                    <input type="hidden" name="image_id" id="pest_image_id">
                </div>

                <div class="form-group">
                    <label>Description</label>
                    <textarea name="description" id="editor">{{ old('description') }}</textarea>
                </div>
            </div>

            <!-- Right Side (Sidebar) -->
            <div>
                <div class="card" style="padding: 1.5rem; border-radius: 15px; position: sticky; top: 20px;">
                    <div class="form-group">
                        <label>Category</label>
                        <select name="pest_category_id" required>
                            <option value="">Select Category</option>
                            @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ old('pest_category_id') == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <button type="submit" class="btn btn-primary" style="width:100%; padding: 1rem; margin-top: 1rem;">
                        <i class="fas fa-save"></i> Save Pest
                    </button>
                    <button type="reset" class="btn btn-secondary" style="width:100%; margin-top: 0.5rem;">Reset Form</button>
                </div>
            </div>
        </div>
    </form>
</div>

@include('admin.partials.picker-modal')
@endsection

@section('scripts')
<script src="https://cdn.ckeditor.com/ckeditor5/40.0.0/classic/ckeditor.js"></script>
<script>
    ClassicEditor
        .create(document.querySelector('#editor'))
        .catch(error => {
            console.error(error);
        });
</script>
@endsection
