@extends('layouts.admin')

@section('title', 'Home Banner Section')
@section('page_title', 'Home Banner CMS')

@section('content')
<div class="card" style="max-width: 800px; margin: 0 auto;">
    <div class="card-header">
        <h2>Update Banner Content</h2>
    </div>
    <div style="padding: 2rem;">
        <form action="{{ route('admin.pages.home.banner.update') }}" method="POST">
            @csrf
            
            <div class="form-group">
                <label>Main Heading</label>
                <input type="text" name="banner[heading]" class="form-control" value="{{ $banner->heading }}" placeholder="The central heading">
            </div>

            <div class="form-group">
                <label>Description Paragraph</label>
                <textarea name="banner[paragraph]" class="form-control" rows="4" placeholder="Brief descriptive text...">{{ $banner->paragraph }}</textarea>
            </div>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 2rem;">
                <div class="form-group">
                    <label>First Button Text</label>
                    <input type="text" name="banner[btn1_text]" class="form-control" value="{{ $banner->btn1_text }}">
                </div>
                <div class="form-group">
                    <label>Second Button Text</label>
                    <input type="text" name="banner[btn2_text]" class="form-control" value="{{ $banner->btn2_text }}">
                </div>
            </div>

            <div style="text-align: right; padding-top: 1.5rem; border-top: 1px solid #eee;">
                <button type="submit" class="btn btn-primary" style="padding: 0.8rem 3rem; font-weight: 700;">
                    SAVE BANNER UPDATES
                </button>
            </div>
        </form>
    </div>
</div>

<div class="card" style="max-width: 800px; margin: 30px auto; background: #1e293b; color: white; overflow: hidden;">
    <div style="padding: 3rem; text-align: center;">
        <h4 style="color: #94a3b8; text-transform: uppercase; letter-spacing: 2px; margin-bottom: 1rem; font-size: 0.8rem;">Live Preview Mockup</h4>
        <h2 style="font-size: 2.5rem; margin-bottom: 1.5rem; color: #fff;">{{ $banner->heading ?: 'Your Heading Here' }}</h2>
        <p style="color: #cbd5e0; max-width: 600px; margin: 0 auto 2rem; line-height: 1.6;">{{ $banner->paragraph ?: 'Placeholder for your banner description text.' }}</p>
        <div style="display:flex; gap: 15px; justify-content:center;">
            <span style="padding: 12px 30px; background: var(--primary-red); border-radius: 8px; font-weight: 700;">{{ $banner->btn1_text ?: 'Button 1' }}</span>
            <span style="padding: 12px 30px; background: transparent; border: 2px solid #fff; border-radius: 8px; font-weight: 700;">{{ $banner->btn2_text ?: 'Button 2' }}</span>
        </div>
    </div>
</div>
@endsection
