@extends('layouts.admin')

@section('title', 'Footer CMS')
@section('page_title', 'Footer Section')

@section('content')
<div class="card">
    <div class="card-header">
        <h2>Footer Settings</h2>
    </div>
    <form action="{{ route('admin.pages.footer.update') }}" method="POST">
        @csrf
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label>Footer Logo</label>
                    <div style="margin-bottom: 10px;">
                        <img id="footerLogoPreview" src="{{ $footer->logo ? asset($footer->logo) : 'https://placehold.co/200x80' }}" style="max-width: 100%; height: auto; border-radius: 8px; border: 1px solid #ddd; background: #f8fafc; padding: 10px;">
                    </div>
                    <input type="hidden" name="footer[logo]" id="footerLogoInput" value="{{ $footer->logo }}">
                    <button type="button" class="btn btn-secondary w-100" onclick="openCMSPicker('footerLogoInput', 'footerLogoPreview')">
                        <i class="fas fa-image"></i> Select Logo
                    </button>
                </div>
            </div>
            <div class="col-md-8">
                <div class="form-group">
                    <label>About Paragraph</label>
                    <textarea name="footer[paragraph]" class="form-control" rows="4">{{ $footer->paragraph }}</textarea>
                </div>
            </div>
        </div>

        <div class="row" style="margin-top: 1.5rem;">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Address</label>
                    <input type="text" name="footer[address]" value="{{ $footer->address }}" class="form-control">
                </div>
                <div class="form-group">
                    <label>Phone Number</label>
                    <input type="text" name="footer[phone]" value="{{ $footer->phone }}" class="form-control">
                </div>
                <div class="form-group">
                    <label>Email Address</label>
                    <input type="email" name="footer[email]" value="{{ $footer->email }}" class="form-control">
                </div>
            </div>
            <div class="col-md-6">
                <div class="row" style="background: #f8fafc; padding: 1.5rem; border-radius: 12px; margin: 0;">
                    <div class="col-12" style="padding: 0;">
                        <div class="form-group">
                            <label>Tag Name</label>
                            <input type="text" name="footer[tag_name]" value="{{ $footer->tag_name }}" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Tag Icon (FontAwesome)</label>
                            <input type="text" name="footer[tag_icon]" value="{{ $footer->tag_icon }}" class="form-control" placeholder="fas fa-certificate">
                        </div>
                        <div class="form-group" style="margin-bottom: 0;">
                            <label>Tag Text</label>
                            <input type="text" name="footer[tag_text]" value="{{ $footer->tag_text }}" class="form-control">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div style="margin-top: 2rem; text-align: right;">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="fas fa-save"></i> Save Footer
            </button>
        </div>
    </form>
</div>
@endsection

@section('styles')
<style>
    .row { display: flex; flex-wrap: wrap; margin-right: -15px; margin-left: -15px; }
    .col-md-4 { flex: 0 0 33.333333%; max-width: 33.333333%; padding: 0 15px; }
    .col-md-8 { flex: 0 0 66.666667%; max-width: 66.666667%; padding: 0 15px; }
    .col-md-6 { flex: 0 0 50%; max-width: 50%; padding: 0 15px; }
    .col-12 { flex: 0 0 100%; max-width: 100%; padding: 0 15px; }
    .form-control { width: 100%; padding: 0.8rem 1rem; border: 2px solid #edf2f7; border-radius: 10px; font-size: 1rem; }
    .w-100 { width: 100%; }
</style>
@endsection
