@extends('layouts.admin')

@section('title', 'Contact Us CMS')
@section('page_title', 'Contact Info Section')

@section('content')
<div class="card">
    <div class="card-header">
        <h2>Contact Information</h2>
    </div>
    <form action="{{ route('admin.pages.contact.update') }}" method="POST">
        @csrf
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Main Office Address</label>
                    <textarea name="contact[address]" class="form-control" rows="3">{{ $contact->address }}</textarea>
                </div>
                <div class="form-group">
                    <label>Phone Number</label>
                    <input type="text" name="contact[phone]" value="{{ $contact->phone }}" class="form-control">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Toll Free Number</label>
                    <input type="text" name="contact[toll_free]" value="{{ $contact->toll_free }}" class="form-control">
                </div>
                <div class="form-group">
                    <label>Fax Number</label>
                    <input type="text" name="contact[fax]" value="{{ $contact->fax }}" class="form-control">
                </div>
                <div class="form-group">
                    <label>Email Address</label>
                    <input type="email" name="contact[email]" value="{{ $contact->email }}" class="form-control">
                </div>
            </div>
        </div>

        <div style="margin-top: 2rem; text-align: right;">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="fas fa-save"></i> Save Contact Info
            </button>
        </div>
    </form>
</div>

<div class="card" style="margin-top: 2rem;">
    <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
        <h2>Recent Contact Messages</h2>
        <a href="{{ route('admin.contact.messages') }}" class="btn btn-secondary btn-sm">View All Messages</a>
    </div>
    <p style="color: #64748b; font-size: 0.9rem;">Manage and respond to messages from the contact form.</p>
</div>
@endsection

@section('styles')
<style>
    .row { display: flex; flex-wrap: wrap; margin-right: -15px; margin-left: -15px; }
    .col-md-6 { flex: 0 0 50%; max-width: 50%; padding: 0 15px; }
    .form-control { width: 100%; padding: 0.8rem 1rem; border: 2px solid #edf2f7; border-radius: 10px; font-size: 1rem; }
</style>
@endsection
