@extends('layouts.admin')

@section('title', 'About Us CMS')
@section('page_title', 'About Us Section')

@section('content')
<div class="card">
    <div class="card-header">
        <h2>About Us - Hero Section</h2>
    </div>
    <form action="{{ route('admin.pages.about.update') }}" method="POST">
        @csrf
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label>Hero Image</label>
                    <div style="margin-bottom: 10px;">
                        <img id="heroImagePreview" src="{{ $hero->image ? asset($hero->image) : 'https://placehold.co/600x400' }}" style="width: 100%; border-radius: 8px; border: 1px solid #ddd;">
                    </div>
                    <input type="hidden" name="hero[image]" id="heroImageInput" value="{{ $hero->image }}">
                    <button type="button" class="btn btn-secondary w-100" onclick="openCMSPicker('heroImageInput', 'heroImagePreview')">
                        <i class="fas fa-image"></i> Select Image
                    </button>
                </div>
            </div>
            <div class="col-md-8">
                <div class="form-group">
                    <label>Heading</label>
                    <input type="text" name="hero[heading]" value="{{ $hero->heading }}" class="form-control">
                </div>
                <div class="form-group">
                    <label>Paragraph</label>
                    <textarea name="hero[paragraph]" class="form-control" rows="4">{{ $hero->paragraph }}</textarea>
                </div>
            </div>
        </div>

        <hr style="margin: 2rem 0; border-top: 2px dashed #eee;">

        <div class="card-header" style="border: none; padding-left: 0;">
            <h2>About Us - Main Section</h2>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Main Heading</label>
                    <input type="text" name="main[heading]" value="{{ $main->heading }}" class="form-control">
                </div>
                <div class="form-group">
                    <label>Long Description</label>
                    <textarea name="main[description]" class="form-control" rows="6">{{ $main->description }}</textarea>
                </div>
                <div class="form-group">
                    <label>Quote</label>
                    <textarea name="main[quote]" class="form-control" rows="3">{{ $main->quote }}</textarea>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Main Image</label>
                    <div style="margin-bottom: 10px;">
                        <img id="mainImagePreview" src="{{ $main->image ? asset($main->image) : 'https://placehold.co/600x400' }}" style="width: 100%; border-radius: 8px; border: 1px solid #ddd;">
                    </div>
                    <input type="hidden" name="main[image]" id="mainImageInput" value="{{ $main->image }}">
                    <button type="button" class="btn btn-secondary w-100" onclick="openCMSPicker('mainImageInput', 'mainImagePreview')">
                        <i class="fas fa-image"></i> Select Image
                    </button>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Button Text</label>
                            <input type="text" name="main[btn_text]" value="{{ $main->btn_text }}" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Button URL</label>
                            <input type="text" name="main[btn_url]" value="{{ $main->btn_url }}" class="form-control">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row" style="margin-top: 1rem; background: #f8fafc; padding: 1.5rem; border-radius: 12px;">
            <div class="col-md-4">
                <div class="form-group">
                    <label>Tag Icon (FontAwesome)</label>
                    <input type="text" name="main[tag_icon]" value="{{ $main->tag_icon }}" class="form-control" placeholder="fas fa-check">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label>Tag Heading</label>
                    <input type="text" name="main[tag_heading]" value="{{ $main->tag_heading }}" class="form-control">
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label>Tag Paragraph</label>
                    <input type="text" name="main[tag_paragraph]" value="{{ $main->tag_paragraph }}" class="form-control">
                </div>
            </div>
            <div class="col-12">
                <div class="form-group" style="margin-bottom: 0;">
                    <label>Bottom Tag Text</label>
                    <input type="text" name="main[bottom_tag]" value="{{ $main->bottom_tag }}" class="form-control">
                </div>
            </div>
        </div>

        <div style="margin-top: 2rem; text-align: right;">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="fas fa-save"></i> Save All Changes
            </button>
        </div>
    </form>
</div>
@endsection

@section('styles')
<style>
    .row { display: flex; flex-wrap: wrap; margin-right: -15px; margin-left: -15px; }
    .col-md-4 { flex: 0 0 33.333333%; max-width: 33.333333%; padding: 0 15px; }
    .col-md-8 { flex: 0 0 66.666667%; max-width: 66.666667%; padding: 0 15px; }
    .col-md-6 { flex: 0 0 50%; max-width: 50%; padding: 0 15px; }
    .col-12 { flex: 0 0 100%; max-width: 100%; padding: 0 15px; }
    .form-control { width: 100%; padding: 0.8rem 1rem; border: 2px solid #edf2f7; border-radius: 10px; font-size: 1rem; }
    .w-100 { width: 100%; }
    .btn-lg { padding: 1rem 2rem; font-size: 1.1rem; }
</style>
@endsection
