@extends('layouts.admin')

@section('title', 'Add Navbar Link')

@section('content')
<div style="max-width: 800px; margin: 0 auto;">
    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
        <h2 style="font-size: 1.5rem; color: #1a202c;">Add Navbar Link</h2>
        <a href="{{ route('admin.navbar-links.index') }}" class="btn btn-secondary">Back to List</a>
    </div>

    <div class="card" style="padding: 2rem;">
        <form action="{{ route('admin.navbar-links.store') }}" method="POST">
            @csrf

            <div class="form-group" style="margin-bottom: 1.5rem;">
                <label>Title</label>
                <input type="text" name="title" class="form-control" required>
            </div>

            <div class="form-group" style="margin-bottom: 1.5rem;">
                <label>URL</label>
                <input type="text" name="url" class="form-control" required placeholder="/services or https://example.com">
            </div>

            <div class="form-group" style="margin-bottom: 1.5rem;">
                <label>Order</label>
                <input type="number" name="order" class="form-control" value="0">
            </div>

            <div class="form-group" style="margin-bottom: 1.5rem;">
                <label>Status</label>
                <select name="status" class="form-control">
                    <option value="1">Active</option>
                    <option value="0">Inactive</option>
                </select>
            </div>

            <div style="display: flex; justify-content: flex-end; gap: 1rem; margin-top: 2rem;">
                <button type="submit" class="btn btn-primary">Create Link</button>
            </div>
        </form>
    </div>
</div>
@endsection
