@extends('layouts.admin')

@section('title', 'Distributors')
@section('page_title', 'Manage Distributors')

@section('content')
<div class="card">
    <div class="card-header">
        <h2>Distributors List</h2>
        <a href="{{ route('admin.distributors.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Add New Distributor
        </a>
    </div>

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Image</th>
                    <th>Name</th>
                    <th>Slug</th>
                    <th>Created At</th>
                    <th style="text-align: right;">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($distributors as $item)
                <tr>
                    <td style="width: 80px;">
                        <img src="{{ $item->imageFile ? asset($item->imageFile->path) : 'https://placehold.co/50x50' }}" style="width: 50px; height: 50px; border-radius: 8px; object-fit: cover; border: 1px solid #eee;">
                    </td>
                    <td style="font-weight: 600;">{{ $item->name }}</td>
                    <td><code>{{ $item->slug }}</code></td>
                    <td>{{ $item->created_at->format('M d, Y') }}</td>
                    <td>
                        <div style="display: flex; gap: 8px; justify-content: flex-end;">
                            <a href="{{ route('admin.distributors.edit', $item) }}" class="action-btn btn-edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            <form action="{{ route('admin.distributors.destroy', $item) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this distributor?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="action-btn btn-delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" style="text-align: center; padding: 3rem;">
                        <i class="fas fa-truck" style="font-size: 3rem; color: #e2e8f0; margin-bottom: 1rem; display: block;"></i>
                        No distributors found.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div style="margin-top: 1.5rem;">
        {{ $distributors->links() }}
    </div>
</div>
@endsection