@extends('layouts.admin')

@section('title', 'Add Distributor')
@section('page_title', 'New Distributor')

@section('content')
<div class="card" style="max-width: 600px; margin: 0 auto;">
    <div class="card-header">
        <h2>Add New Distributor</h2>
    </div>
    <form action="{{ route('admin.distributors.store') }}" method="POST">
        @csrf
        <div class="form-group">
            <label>Name</label>
            <input type="text" name="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name') }}" required>
            @error('name') <div style="color: var(--primary-red); font-size: 0.8rem; margin-top: 5px;">{{ $message }}</div> @enderror
        </div>

        <div class="form-group">
            <label>Distributor Logo/Image</label>
            <div style="margin-bottom: 10px;">
                <img id="imagePreview" src="https://placehold.co/150x150" style="width: 150px; height: 150px; border-radius: 12px; border: 1px solid #ddd; object-fit: cover; display: none;">
            </div>
            <input type="hidden" name="image" id="imageInput" value="{{ old('image') }}">
            <button type="button" class="btn btn-secondary" onclick="openCMSPicker('imageInput', 'imagePreview')" style="width: 100%;">
                <i class="fas fa-image"></i> Select Image
            </button>
        </div>

        <div style="margin-top: 2rem; display: flex; gap: 10px; justify-content: flex-end;">
            <a href="{{ route('admin.distributors.index') }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Save Distributor
            </button>
        </div>
    </form>
</div>
@endsection
