@extends('layouts.admin')

@section('title', 'Manage Categories')

@section('content')
<div class="card">
    <div class="card-header">
        <h2 style="font-size: 1.2rem;">Categories</h2>
        <button class="btn btn-primary" onclick="openCategoryModal()">
            <i class="fas fa-plus"></i> Add Category
        </button>
    </div>

    @if(session('success'))
    <div style="background: #d4edda; color: #155724; padding: 1rem; border-radius: 6px; margin-bottom: 1.5rem;">
        {{ session('success') }}
    </div>
    @endif

    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th>Image</th>
                    <th>Name</th>
                    <th>Slug</th>
                    <th>Icon</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($categories as $category)
                <tr>
                    <td>
                        @if($category->image)
                        <img src="/{{ $category->image->path }}" style="width: 50px; height: 50px; object-fit: cover; border-radius: 8px;">
                        @else
                        <div style="width: 50px; height: 50px; background: #f1f1f1; border-radius: 8px; display: flex; align-items:center; justify-content:center;">
                            <i class="fas fa-image" style="color:#ccc;"></i>
                        </div>
                        @endif
                    </td>
                    <td style="font-weight: 600;">{{ $category->name }}</td>
                    <td>{{ $category->slug }}</td>
                    <td><i class="{{ $category->icon }}"></i></td>
                    <td>
                                            <div style="display: flex; gap: 8px;">

                        <button class="action-btn btn-edit" onclick="editCategory({{ json_encode($category) }})">
                            <i class="fas fa-edit"></i>
                        </button>
                        <form action="{{ route('admin.categories.destroy', $category->id) }}" method="POST" style="display:inline;" onsubmit="return confirm('Delete category?')">
                            @csrf @method('DELETE')
                            <button type="submit" class="action-btn btn-delete">
                                <i class="fas fa-trash"></i>
                            </button>
                        </form>
</div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="5" style="padding: 2rem; text-align: center; color: #666;">No categories found</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    <div class="pagination">
        {{ $categories->links() }}
    </div>
</div>

<!-- Category CRUD Modal -->
<div id="categoryModal" class="modal">
    <div class="modal-content" style="max-width: 800px; padding: 0; border-radius: 20px; overflow: hidden;">
        <div class="modal-header" style="background: #f8fafc; padding: 1.5rem 2rem; border-bottom: 1px solid #edf2f7; display: flex; justify-content: space-between; align-items: center;">
            <h3 id="categoryModalTitle" style="margin:0; font-size: 1.25rem;">Add Category</h3>
            <button type="button" class="btn btn-secondary" onclick="closeModal('categoryModal')" style="padding: 0.5rem 1rem;">
                <i class="fas fa-times"></i>
            </button>
        </div>

        <form id="categoryForm" action="{{ route('admin.categories.store') }}" method="POST">
            @csrf
            <input type="hidden" name="_method" id="categoryMethod" value="POST">

            <div style="padding: 2rem; max-height: 70vh; overflow-y: auto;">
                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 2rem; margin-bottom: 2rem;">
                    <div class="form-group">
                        <label style="font-weight: 700; color: #4a5568; margin-bottom: 0.5rem; display: block;">Category Name</label>
                        <input type="text" name="name" id="cat_name" placeholder="E.g. Indoor Plants" required style="width: 100%;">
                    </div>
                    <div class="form-group">
                        <label style="font-weight: 700; color: #4a5568; margin-bottom: 0.5rem; display: block;">Slug (Optional)</label>
                        <input type="text" name="slug" id="cat_slug" placeholder="indoor-plants" style="width: 100%;">
                    </div>
                </div>

                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 2rem; margin-bottom: 2rem;">
                    <div class="form-group">
                        <label style="font-weight: 700; color: #4a5568; margin-bottom: 0.5rem; display: block;">Icon Class (Optional)</label>
                        <input type="text" name="icon" id="cat_icon" placeholder="fas fa-leaf" style="width: 100%;">
                    </div>
                    <div class="form-group">
                        <label style="font-weight: 700; color: #4a5568; margin-bottom: 0.5rem; display: block;">Category Image</label>
                        <div style="display:flex; gap: 15px; align-items: center;">
                            <input type="hidden" name="image_id" id="cat_image_id">
                            <div id="cat_image_preview" style="width: 100px; height: 100px; background: #f8fafc; border-radius: 15px; border: 2px dashed #edf2f7; display: flex; align-items:center; justify-content:center; overflow:hidden; cursor: pointer;" onclick="openPicker('single', 'cat_image_id', 'cat_image_preview')">
                                <i class="fas fa-image" style="font-size: 2rem; color:#cbd5e0;"></i>
                            </div>
                            <button type="button" class="btn btn-secondary btn-sm" onclick="openPicker('single', 'cat_image_id', 'cat_image_preview')">
                                <i class="fas fa-images"></i> Browse
                            </button>
                        </div>
                    </div>
                </div>

                <div class="form-group" style="margin-bottom: 2rem;">
                    <label style="font-weight: 700; color: #4a5568; margin-bottom: 0.5rem; display: block;">Description</label>
                    <textarea name="description" id="cat_description" style="min-height: 100px; width: 100%;" placeholder="Describe this category..."></textarea>
                </div>

                <div style="background: #f8fafc; padding: 2rem; border-radius: 15px; border: 1px solid #edf2f7;">
                    <h4 style="margin-top:0; margin-bottom: 1.5rem; font-size: 1rem; color: #2d3748; display: flex; align-items: center; gap: 10px;">
                        <i class="fas fa-search-plus" style="color: var(--primary-red);"></i> SEO Settings
                    </h4>
                    <div class="form-group">
                        <label style="font-weight: 600; color: #4a5568; margin-bottom: 0.5rem; display: block;">Meta Title</label>
                        <input type="text" name="meta_title" id="cat_meta_title" style="width: 100%;">
                    </div>
                    <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 1.5rem; margin-top: 1rem;">
                        <div class="form-group">
                            <label style="font-weight: 600; color: #4a5568; margin-bottom: 0.5rem; display: block;">Meta Keywords</label>
                            <input type="text" name="meta_keywords" id="cat_meta_keywords" style="width: 100%;">
                        </div>
                        <div class="form-group">
                            <label style="font-weight: 600; color: #4a5568; margin-bottom: 0.5rem; display: block;">Meta Description</label>
                            <textarea name="meta_description" id="cat_meta_description" style="min-height: 80px; width: 100%;"></textarea>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal-footer" style="padding: 1.5rem 2rem; background: #f8fafc; border-top: 1px solid #edf2f7; display:flex; justify-content: flex-end; gap: 12px;">
                <button type="button" class="btn btn-secondary" onclick="closeModal('categoryModal')">Cancel</button>
                <button type="submit" class="btn btn-primary" style="padding-left: 2rem; padding-right: 2rem;">
                    <i class="fas fa-save"></i> Save Category
                </button>
            </div>
        </form>
    </div>
</div>

@include('admin.partials.picker-modal')

@endsection

@section('scripts')
<script>
    function openCategoryModal() {
        document.getElementById('categoryModalTitle').innerText = 'Add Category';
        document.getElementById('categoryForm').action = "{{ route('admin.categories.store') }}";
        document.getElementById('categoryMethod').value = 'POST';
        document.getElementById('categoryForm').reset();
        document.getElementById('cat_image_preview').innerHTML = '';
        openModal('categoryModal');
    }

    function editCategory(category) {
        document.getElementById('categoryModalTitle').innerText = 'Edit Category';
        document.getElementById('categoryForm').action = "{{ url('admin/categories') }}/" + category.id;
        document.getElementById('categoryMethod').value = 'PUT';

        document.getElementById('cat_name').value = category.name;
        document.getElementById('cat_slug').value = category.slug;
        document.getElementById('cat_icon').value = category.icon;
        document.getElementById('cat_image_id').value = category.image_id;
        document.getElementById('cat_description').value = category.description;
        document.getElementById('cat_meta_title').value = category.meta_title;
        document.getElementById('cat_meta_keywords').value = category.meta_keywords;
        document.getElementById('cat_meta_description').value = category.meta_description;

        if (category.image) {
            document.getElementById('cat_image_preview').innerHTML = `<img src="/${category.image.path}" style="width:100%; height:100%; object-fit:cover;">`;
        } else {
            document.getElementById('cat_image_preview').innerHTML = '';
        }

        openModal('categoryModal');
    }
</script>
@endsection