<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('images', function (Blueprint $blueprint) {
            $blueprint->id();
            $blueprint->foreignId('folder_id')->nullable()->constrained()->onDelete('cascade');
            $blueprint->string('filename');
            $blueprint->string('original_name');
            $blueprint->string('path');
            $blueprint->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('images');
    }
};
