<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Pest extends Model
{
    protected $fillable = ['pest_category_id', 'title', 'slug', 'image_id', 'description'];

    public function category()
    {
        return $this->belongsTo(PestCategory::class, 'pest_category_id');
    }

    public function image()
    {
        return $this->belongsTo(Image::class);
    }
}
