<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'icon',
        'image_id',
        'description',
        'meta_title',
        'meta_keywords',
        'meta_description'
    ];

    protected static function boot()
    {
        parent::boot();
        static::creating(function ($category) {
            if (empty($category->slug)) {
                $category->slug = \Illuminate\Support\Str::slug($category->name);
            }
        });
    }

    public function image()
    {
        return $this->belongsTo(Image::class, 'image_id');
    }

    public function products()
    {
        return $this->hasMany(Product::class);
    }
}
