<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Image;
use App\Models\Testimonial;
use Illuminate\Http\Request;

class TestimonialController extends Controller
{
    public function index()
    {
        $testimonials = Testimonial::with('imageFile')->latest()->get();

        $data = $testimonials->map(function ($testimonial) {
            $item = $testimonial->toArray();
            if (isset($item['client_image']) && is_numeric($item['client_image'])) {
                $image = Image::find($item['client_image']);
                $item['client_image'] = $image ? $image->path : null;
            }
            return $item;
        });

        return response()->json($data);
    }
}
