<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Distributor;
use Illuminate\Http\Request;

class DistributorController extends Controller
{
    public function index()
    {
        return response()->json(Distributor::with('imageFile')->latest()->get());
    }

    public function show($slug)
    {
        $distributor = Distributor::with('imageFile')->where('slug', $slug)->firstOrFail();
        return response()->json($distributor);
    }
}
