<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\WhyChooseUsCard;
use Illuminate\Http\Request;

class WhyChooseUsController extends Controller
{
    public function index()
    {
        $cards = WhyChooseUsCard::latest()->get();
        return view('admin.why-choose-us.index', compact('cards'));
    }

    public function create()
    {
        return view('admin.why-choose-us.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'heading' => 'required|string|max:255',
            'paragraph' => 'nullable|string',
            'icon' => 'nullable|string'
        ]);

        WhyChooseUsCard::create($request->all());

        return redirect()->route('admin.why-choose-us.index')->with('success', 'Feature card added successfully.');
    }

    public function edit(WhyChooseUsCard $why_choose_u)
    {
        $card = $why_choose_u;
        return view('admin.why-choose-us.edit', compact('card'));
    }

    public function update(Request $request, WhyChooseUsCard $why_choose_u)
    {
        $request->validate([
            'heading' => 'required|string|max:255',
            'paragraph' => 'nullable|string',
            'icon' => 'nullable|string'
        ]);

        $why_choose_u->update($request->all());

        return redirect()->route('admin.why-choose-us.index')->with('success', 'Feature card updated successfully.');
    }

    public function destroy(WhyChooseUsCard $why_choose_u)
    {
        $why_choose_u->delete();
        return back()->with('success', 'Feature card deleted successfully.');
    }
}
