<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Registration;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class RegistrationController extends Controller
{
    public function index()
    {
        $registrations = Registration::with('imageFile')->latest()->paginate(10);
        return view('admin.registrations.index', compact('registrations'));
    }

    public function create()
    {
        return view('admin.registrations.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'image' => 'nullable|string'
        ]);

        Registration::create([
            'name' => $request->name,
            'slug' => Str::slug($request->name),
            'image' => $request->image
        ]);

        return redirect()->route('admin.registrations.index')->with('success', 'Registration added successfully.');
    }

    public function edit(Registration $registration)
    {
        return view('admin.registrations.edit', compact('registration'));
    }

    public function update(Request $request, Registration $registration)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'image' => 'nullable|string'
        ]);

        $registration->update([
            'name' => $request->name,
            'slug' => Str::slug($request->name),
            'image' => $request->image
        ]);

        return redirect()->route('admin.registrations.index')->with('success', 'Registration updated successfully.');
    }

    public function destroy(Registration $registration)
    {
        $registration->delete();
        return back()->with('success', 'Registration deleted successfully.');
    }
}
